/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

@import Foundation;

#import "PBMConstants.h"

// MARK: -
@protocol PBMJsonDecodable <NSObject>

- (nullable instancetype)initWithJsonDictionary:(nonnull PBMJsonDictionary *)jsonDictionary
                                          error:(NSError * _Nullable __autoreleasing * _Nullable)error;

@end

// MARK: -
@protocol PBMJsonStringDecodable <PBMJsonDecodable>

- (nullable instancetype)initWithJsonString:(nonnull NSString *)jsonString
                                      error:(NSError * _Nullable __autoreleasing * _Nullable)error;

@end
