/*   Copyright 2014 APPNEXUS INC
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

#import <WebKit/WebKit.h>

@interface ANWebView : WKWebView

 -(instancetype) initWithSize:(CGSize)size;
    
    -(instancetype) initWithSize:(CGSize)size
                             URL:(NSURL *)URL
                         baseURL:(NSURL *)baseURL ;
    
    -(instancetype) initWithSize:(CGSize)size
                             content:(NSString *)htmlContent
                         baseURL:(NSURL *)baseURL;
    
    -(instancetype) initWithSize:(CGSize)size URL:(NSURL *)URL;
    -(instancetype) initWithSize:(CGSize)size
                         content:(NSString *)htmlContent
                         baseURL:(NSURL *)baseURL
             isNativeRenderingAd:(BOOL)nativeRenderingAd;


 -(void) loadWithSize:(CGSize)size content:(NSString *) contentString baseURL:(NSURL *)baseURL;

+ (ANWebView *) fetchWebView;
+ (void) prepareWebView;

+ (WKUserScript *)omidScript;

@property (nonatomic, readwrite, strong)  WKNavigation *navigation;

@end
